
(* 3x3 flyways 1 xbot - DeleteGCode,SaveGCode,ReadGCode,GetGCodeIDs,RunGCode. G-code file 'GCodeDemo.txt' must be in the root directory of the FileDevice *)
FUNCTION_BLOCK FileExample01_Gcode
	//Read testing G-code file from disk 
	Read_file(Execute := Execute,file_device := FileDevice,file_path := 'GCodeDemo.txt',data_adr := ADR(sent_Gcode_data));
	sent_data_size := Read_file.file_size;
	
	//Delete G-code file ID 1
	PMC_DeleteGCode1(Execute := Read_file.Done,GCodeID := 1,PM_Controller := PM_Controller);

	//Send the testing G-code file to the PMC
	PMC_SaveGCode1(Execute := PMC_DeleteGCode1.Done,GCodeID := 1,nBytes := sent_data_size,Bytes := sent_Gcode_data,PM_Controller := PM_Controller);

	//Read back the G-code file from the PMC
	PMC_ReadGCode1(Execute := PMC_SaveGCode1.Done,GCodeID := 1,Bytes := read_Gcode_data,PM_Controller := PM_Controller);
	read_data_size := PMC_ReadGCode1.nBytes;
	
	//Get the IDs of the G-code files on the PMC
	PMC_GetGCodeIDs(Execute := PMC_ReadGCode1.Done,PM_Controller := PM_Controller);	
	
	//Run the testing G-code file
	PMC_RunGCode1(Execute := PMC_GetGCodeIDs.Done,cmdLB := 3,GCodeID := 1,XbotID := 1,PM_Controller := PM_Controller);	
	Done := PMC_RunGCode1.Done;
END_FUNCTION_BLOCK
